c     --------------------------------------------------------------------STIFF
      subroutine stiff (ndatam,propma,numdof,coord,iele,dmat,iadres,
     +bdat,ncheck)
      implicit double precision (a-h, o-z)
c
      dimension propma(ndatam,1),numdof(3,1),coord(2,1),iele(5,1),
     +dmat(4,1),iadres(1),prop(3),lm(8),ek(64),xy(2,4),d(6),
     +edat(36),shp(16),bdat(36,1), ncheck(1)
c
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11,
     +nt12(3)
      common /gauss/ sg(4),tg(4),wg(4),nint
c
c     This routine controls the generation of element stiffness matrices
c      at the beginning of solution step. It also generates the diagonal
c      address array of variable band global stiffness matrix, and the vector
c      of nodal weights.
c
c                          Sudip S.Bhattacahrjee/ January 28,1992/ McGill
c
c.....Initialize the diagonal address matrix.
c
      call izero (d,12)
      neqq=neq+1
      do 100 i=1,neqq
         iadres(i)=i
  100 continue
c.....open the unformatted direct access file *.els 
      call sopen (nsp,'els',-544)
      call sopen (nt8,'ers',-480)
      write (not,4003)
c
c.....START DEVELOPING THE ELEMENT STIFFNESS MATRICES
c
c.....Collect gauss point coordinates and the corresponding weights
c     (2X2 integration)
c
      call pgauss (2,nint,sg,tg,wg)
c
      mati=0
      do 500 n=1,numel
c........Identify the element properties
         mat=iele(5,n)
         if (mat .eq. mati) go to 300
            do 200 i=1,3
               prop(i)=propma(i,mat)
  200       continue
            thk=propma(4,mat)
c...........Form the stress-strain relation matrix
            call formd0 (prop(1),prop(2),d(1))
            do 210 i=1,4
               dmat(i,mat)=d(i)
  210       continue
            mati=mat
  300    continue
c........Nodal coordinates and connectivity for the isop-element
         do 400 i=1,4
            inode=iele(i,n)
            xy(1,i)=coord(1,inode)
            xy(2,i)=coord(2,inode)
            ii=2*i
            lm(ii-1)=numdof(1,inode)
            lm(ii)  =numdof(2,inode)
            ncheck(inode)=ncheck(inode)+1
  400    continue
c........Prepare data to compute bandwidth
         call sband (iadres,lm,8)
c........Generate the element stiffness matrix
         call stiffe (xy,d(1),ek,edat,shp,thk)
	   write (nsp,rec=n) lm,ek
         write (nt8,rec=n) edat,shp
c........modification for windows operation
         call coprr (edat,bdat(1,n),36)
c
c........Calculate the element self-weight and add it to the global vector
c         call slfwt (prop(3),xy,p)
c         do 450 i=1,4
c            inode=iele(i,n)
c            swt(inode)=swt(inode)+p(i)
c  450    continue
c........File *.els contains element coonectivity (lm), stiffness matrix (ek)
c........[B] matrix to compute the strain at the element centroid
c         call formb (bmat(1,n),bmat(9,n),xy,thck)
c
  500 continue
c.....check for beam elements and added stiffness coefficients
      call beamin (coord(1,1),numdof(1,1),iadres(1),ncheck(1))
      if (nbms .ne. 0) call nopen (-nt11,'bmf')
      call checkn (ncheck(1),numnp,numdof(1,1),neqq)
c.....Modify vector iadres to diagonal address
      mband=0
      nsto=0
      do 600 i=1,neq
         nh=i-iadres(i)+1
         if (mband .lt. nh) mband=nh
         nsto=nsto+nh
         iadres(i)=nsto
  600 continue
c.....Print the stiffness matrix size parameters
      write (not,4004) neq,mband,nsto
c.....File *.ess is the post processing file
c      open (nt7,status='unknown',file='c:file.ess',form='unformatted')

c.....File *.bup keeps the backup of mass matrix and dead load vector
      call fopen (nfl,'bup')
c     ----------------------------------------------------------------
 4003 format (///' File *.els contains element coonectivity (lm) and ',
     +'stiffness matrix (ek)'/10x,'**It is an unformatted direct acces',
     +'s file**'//' File *.ers (opened if ks=-1) contains the element',
     +' strain transformation matrix and response quatities at each in',
     +'tegration point'/)
 4004 format (//' Total number of equations:                     ',i7/
     +' The half-band width of the stiffness matrix:   ',i7/
     +' The total number of elements under the profile:',i7)
c
       return
       end
c     -------------------------------------------------------------EQNUM
      subroutine eqnum (nodes)
      dimension nodes(3,1)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     This subroutine assigns numbers to the equations 
c
c                  Sudip S. Bhattacharjee/November 15,1991/McGill
c
c     Modified for displacement control solution on February 18,1992
c
c     number degrees of freedom
c
      numeqn= 0
      do 520 n=1,numnp
         do 510 m=1,3
            kod = nodes(m,n)
            if (kod .lt. 0) go to 510
            if (kod .eq. 0) then
               numeqn=numeqn+1  
               nodes(m,n)=numeqn
             else
               nodes(m,n)=0
            endif
  510    continue
  520 continue
c
      neq=numeqn
      do 525 n=1,numnp
         do 515 m=1,3
            kod = nodes(m,n)
            if (kod .lt. 0) then
               neq=neq+1
               nodes(m,n)=neq
             else
               continue
            endif
  515    continue
  525 continue
c
      neqq=neq+1
c
      do 540 n=1,numnp
         do 530 m=1,3
            kod = nodes(m,n)
            if (kod .eq. 0) nodes(m,n)=neqq
  530    continue
  540 continue
c
      return
      end
c     -----------------------------------------------------------FORMD0
      subroutine formd0 (e,u,d)
      implicit double precision (a-h,o-z)
      dimension d(4)
c
c     This subroutine generates the stress-strain relation matrix
c      for plane-stress isotropic model.
c
c                            Sudip S. Bhattacharjee/November 15,1991/McGill
c
      d11=e/(1-u*u)
      d(1)=d11
      d(2)=U*d11
      d(3)=d11
      d(4)=0.5*(d11-d(2))
      return
      end
c     -----------------------------------------------------------------PGAUSS
      subroutine pgauss(l,nint,r,z,w)
c.....gauss points and weights for two-dimansions
c
c             Adapted from Zienkiewicz and Taylor: Vol.I (p. 538)
c
c                       Sudip S. Bhattacharjee/November 16,1991/McGill
c
c      integer*2 lr(9),lz(9),lw(9)
      integer*2 lr(9),lz(9)
      double precision r(4),z(4),w(4),g
c      double precision r(4),z(4),w(4),g,h
      data lr/-1,1,1,-1,0,1,0,-1,0/, lz/-1,-1,1,1,-1,0,1,0,0/
c      data lw/4*25,4*40,64/
      nint=l*l
      go to (1,2) l
c.....1x1 integration
    1 r(1)=0.0
      z(1)=0.0
      w(1)=4.0
      return
c.....2x2 integration
    2 g=1.d0/dsqrt(3.d0)
      do 21 i=1,4
         r(i)=g*lr(i)
         z(i)=g*lz(i)
         w(i)=1.0
   21 continue
      return
c.....3x3 integration
c    3 g=dsqrt(0.60d0)
c      h=1.d0/81.d0
c      do 31 i=1,9
c         r(i)=g*lr(i)
c         z(i)=g*lz(i)
c         w(i)=h*lw(i)
c   31 continue
c      return
      end
c     -------------------------------------------------------------------STIFFE
      subroutine stiffe (xy,d,ek,edat,sfun,thk)
      implicit double precision (a-h,o-z)
      dimension xy(2,4),d(6),ek(8,8),shp(3,4),edat(36),sfun(16)
      common /gauss/ sg(4),tg(4),wg(4),nint
c
c     Stiffness computation for cracked 2D plane elements.
c
c                             Sudip S. Bhattacharjee/January 03,1992/McGill
c
      call izero (ek,128)
c.....Compute contribution at each integration point
      nsize=8
      ii=0
      jj=0
      do 120 n=1,nint
         call shapef (sg(n),tg(n),xy,xjac,shp)
         dv=xjac*wg(n)*thk
         do 99 j=1,4
            jj=jj+1
            sfun(jj)=shp(3,j)
          do 99 i=1,2
             ii=ii+1
             edat(ii)=shp(i,j)
   99     continue
          ii=ii+1
          edat(ii)=dv
          call btdb (d,shp,dv,ek)
  120 continue
c
c.....Compute lower part by symmetry
c
      do 130 i=2,nsize
      do 130 j=1,i
         ek(i,j)=ek(j,i)
  130 continue
      return
      end
c     --------------------------------------------------------------------BTDB
      subroutine btdb (d,shp,dv,ek)
      implicit double precision (a-h,o-z)
      dimension d(6),shp(3,4),ek(8,8)
c
c.....Computes [B]T[D][B] for a given integration point
c
c                     Sudip S. Bhattacharjee/March 01,1995/Ecole

      nnode=4
      ndof=2
      d11=d(1)*dv
      d12=d(2)*dv
      d22=d(3)*dv
      d33=d(4)*dv
      d13=d(5)*dv
      d23=d(6)*dv
c.....For each j-node compute: DB=D*B
      j1=1
      do 110 j=1,nnode
         db11=d11*shp(1,j)+d13*shp(2,j)
         db12=d12*shp(2,j)+d13*shp(1,j)
         db21=d12*shp(1,j)+d23*shp(2,j)
         db22=d22*shp(2,j)+d23*shp(1,j)
         db31=d33*shp(2,j)+d13*shp(1,j)
         db32=d33*shp(1,j)+d23*shp(2,j)
c
c........For each i-node compute EK=B_t*DB
c
         i1=1
         do 100 i=1,j
            ek(i1  ,j1  )=ek(i1  ,j1  )+shp(1,i)*db11+shp(2,i)*db31
            ek(i1  ,j1+1)=ek(i1  ,j1+1)+shp(1,i)*db12+shp(2,i)*db32
            ek(i1+1,j1  )=ek(i1+1,j1  )+shp(1,i)*db31+shp(2,i)*db21
            ek(i1+1,j1+1)=ek(i1+1,j1+1)+shp(1,i)*db32+shp(2,i)*db22
            i1=i1+ndof
  100    continue
         j1=j1+ndof
  110 continue
c
      return
      end
c     ----------------------------------------------------------------SHAPEF
      subroutine shapef (ss,tt,xl,xsj,shp)
      implicit double precision (a-h,o-z)
c
c.....Shape function routine for 4 node isoparametric element 
c
c          Adapted from Zienkiewicz and Taylor: Vol.I (p. 471)
c
c                     Sudip S. Bhattacharjee/November 16,1991/McGill
c
c           SS,TT    = Natural coordinates for shape functions
c           SHP(1,I) = X-derivative of I-node shape function
c           SHP(2,I) = Y-deirvative of I-node shape function
c           SHP(3,I) = shape function for I-node
c           XS       = Jacobian matrix
c           XSJ      = Jacobian determinant
c           XL(1,I)  = x-ccordinate of node_I
c           XL(2,I)  = y-coordinate of node_I
c
      dimension xl(2,4),si(4),ti(4),shp(3,4),xs(2,2)
      data si/-0.5,0.5,0.5,-0.5/, ti/-0.5,-0.5,0.5,0.5/
c
c.....Compute shape functions and their natural coordinate derivatives
c
      do 100 i=1,4
         shp(1,i)=si(i)*(0.5+ti(i)*tt)
         shp(2,i)=ti(i)*(0.5+si(i)*ss)
         shp(3,i)=(0.5+si(i)*ss)*(0.5+ti(i)*tt)
  100 continue
c
c.....Compute jacobian transformation from X,Y to SS,TT
c
      do 130 i=1,2
         do 120 j=1,2
            temp=0.0
            do 110 k=1,4
               temp=temp+xl(i,k)*shp(j,k)
  110       continue
         xs(i,j)=temp
  120    continue
  130 continue
c
c.....Compute jacobian determinant 
c
      xsj=xs(1,1)*xs(2,2)-xs(1,2)*xs(2,1)
c
c.....Transform to X,Y derivatives
c
      do 140 i=1,4
         temp    =( xs(2,2)*shp(1,i)-xs(2,1)*shp(2,i))/xsj
         shp(2,i)=(-xs(1,2)*shp(1,i)+xs(1,1)*shp(2,i))/xsj
         shp(1,i)=temp
  140 continue
      return
      end
c     ----------------------------------------------------------------SBAND
      subroutine sband (na,lm,kdof)
      dimension na(1),lm(kdof)
c
c.....Prepare data to compute bandwidth
c            Adapted from ANSR
c
      do 20 j=1,kdof
         jj = lm(j)
         nn = na(jj)
         do 10 i=1,kdof
            ii = lm(i)
            if (jj .lt. ii  .or.  ii .ge. nn) go to 10
            na(jj) = ii
            nn = ii
   10    continue
   20 continue
      return
      end
c     ------------------------------------------------------------------BEAMIN
      subroutine beamin (coord,ndof,iadres,ncheck)
      double precision coord(1)
      dimension ndof(1),iadres(1),ncheck(1)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c.....Computes beam stiffness matrices and/or reads added stiffness
c      coefficients
c                                 Sudip S.B./McGill/July 22, 1992
      call find ('ADDB',kb)
      if (kb .eq. 0) then
         call addbm (coord,ndof,iadres,ncheck)
      else
         write (not,1001)
         write (ntm,1001)
      endif
      call find ('ADDK',kk)
      if (kk .eq. 0) then
         call addk (ndof,iadres,ncheck)
      else
         write (not,1002)
         write (ntm,1002)
      endif
c
 1001 format ('---   No beam elements have been defined    ---')
 1002 format ('--- No added stiffness coefficients defined ---')
c
      return
      end
c     -------------------------------------------------------------------ADDBM
      subroutine addbm (coord,ndof,iadres,ncheck)
      implicit double precision (a-h,o-z)
      character*1 blnk,check
      dimension coord(2,1),ndof(1),iadres(1),ncheck(1),itmp(2),ek(36),
     +bprop(10)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     Computes the added beam stiffness matrices
c
      blnk=' '
      ibeam=nbms
      write (not,1001)
  100 continue
      call izero (bprop(1),20)
      call free
      call freeh (' ',check,1,1)
      if (check .eq. blnk) go to 500
c
      nbms=nbms+1
      ncard=numel+nbms
      call freei ('N',itmp,2)
      call freer ('A',bprop(1),1)
      call freer ('E',bprop(2),1)
      call freer ('I',bprop(3),1)
      call freer ('S',bprop(5),1)
      call freer ('Y',bprop(6),1)
      call freer ('H',bprop(7),1)
      call freer ('D',bprop(8),1)
c
      i1=itmp(1)
      i2=itmp(2)
c
      ncheck(i1)=ncheck(i1)+1
      ncheck(i2)=ncheck(i2)+1
c
      dxl=coord(1,i2)-coord(1,i1)
      dyl=coord(2,i2)-coord(2,i1)
      totl=dsqrt(dxl*dxl+dyl*dyl)
      bprop(4)=totl
      theta=datan2(dyl,dxl)
      thtadg=57.29577951*theta
c
      area=bprop(1)
      emod=bprop(2)
      ztia=bprop(3)
      write (not,2001) nbms,i1,i2,totl,area,ztia,emod,thtadg,
     +(bprop(j),j=5,8)
      call beamk (totl,area,ztia,emod,theta,ek,bprop)
      call lmdat (i1,i2,ndof,iadres,ek,ncard,neq,nsp,bprop)
c
      itmp(1)=0
      itmp(2)=0
      call freei ('G',itmp,2)
      incr=itmp(1)
      mm=itmp(2)
      if (incr .eq. 0  .or.  mm .eq. 0) go to 100
      do 200 n=1,mm
         i1=i1+incr
         i2=i2+incr
c
         ncheck(i1)=ncheck(i1)+1
         ncheck(i2)=ncheck(i2)+1
c.....................modification for the generation/Feb.95
         dxn=coord(1,i2)-coord(1,i1)
         dyn=coord(2,i2)-coord(2,i1)
         dxx=dxn-dxl
         dyy=dyn-dyl
         if (dabs(dxx) .gt. 1.0e-8  .or.  dabs(dyy) .gt. 1.0e-8) then
            dxl=dxn
            dyl=dyn
            totl=dsqrt(dxl*dxl+dyl*dyl)
            bprop(4)=totl
            theta=datan2(dyl,dxl)
            thtadg=57.29577951*theta
            call beamk (totl,area,ztia,emod,theta,ek,bprop)
         endif
c......................end of modification
         nbms=nbms+1
         write (not,2001) nbms,i1,i2,totl,area,ztia,emod,thtadg,
     +   (bprop(j),j=5,8)
         ncard=numel+nbms
         call lmdat (i1,i2,ndof,iadres,ek,ncard,neq,nsp,bprop)
  200 continue
      go to 100
c
  500 continue
      nbeam=nbms-ibeam
      write (not,5001) nbeam
      write (ntm,5001) nbeam
c
 1001 format (15x,'ADDED BEAM PROPERTIES'//'El. No.',4x,'End nodes',5x,
     +'Length',5x,'Area',5x,'Mom. of iner.',5x,'Ela. mod.',5x,'Inclina',
     +'tion',5x,'sigma_0',5x,'sigma_y',5x,'Hardening coeff.',5x,'Ducti',
     +'lity')
 2001 format (i6,3x,i5,',',i5,1x,e11.4,1x,e11.4,1x,e13.5,3x,e13.5,3x,
     +f11.5,2x,e12.4,1x,e12.5,2x,f15.5,4x,f11.5)
 5001 format (' Total',i5,'  beam elements added to the model')
c
      return
      end
c     -------------------------------------------------------------------BEAMK
      subroutine beamk (totl,area,ztia,emod,theta,ek,bprop)
      implicit double precision (a-h,o-z)
      dimension ek(6,6),bprop(10)
c
      nsize=6
      call izero (ek,72)
      ct=dcos(theta)
      st=dsin(theta)
      bprop(9)=ct
      bprop(10)=st
      c2=ct*ct
      s2=st*st
      cs=ct*st
      totl2=totl*totl
      ei=emod*ztia
      term1=area*emod/totl
      term2=12.0*ei/(totl2*totl)
      term3=6.*ei/totl2
      term4=2.0*ei/totl
c
      ek(1,1)=term1*c2+term2*s2
      ek(1,2)=(term1-term2)*cs
      ek(1,3)=-term3*st
      ek(1,4)=-term1*c2-term2*s2
      ek(1,5)=(-term1+term2)*cs
      ek(1,6)=ek(1,3)
      ek(2,2)=term1*s2+term2*c2
      ek(2,3)=term3*ct
      ek(2,4)=ek(1,5)
      ek(2,5)=-ek(2,2)
      ek(2,6)=ek(2,3)
      ek(3,3)=2.0*term4
      ek(3,4)=-ek(1,3)
      ek(3,5)=-ek(2,3)
      ek(3,6)=term4
      ek(4,4)=ek(1,1)
      ek(4,5)=ek(1,2)
      ek(4,6)=-ek(1,3)
      ek(5,5)=ek(2,2)
      ek(5,6)=-ek(2,3)
      ek(6,6)=ek(3,3)
c.....Compute lower part by symmetry
      do 130 i=2,nsize
      do 130 j=1,i
         ek(i,j)=ek(j,i)
  130 continue
      return
      end
c     --------------------------------------------------------------------LMDAT
      subroutine lmdat (i1,i2,ndof,iadres,ek,ncard,neq,nsp,bprop)
      double precision ek(36),bprop(10)
      dimension ndof(3,1),iadres(1),lm(6)
c
      lm(1)=ndof(1,i1)
      lm(2)=ndof(2,i1)
      lm(3)=ndof(3,i1)
      if (i2 .eq. 0) then
         neqq=neq+1
         lm(4)=neqq
         lm(5)=neqq
         lm(6)=neqq
      else
         lm(4)=ndof(1,i2)
         lm(5)=ndof(2,i2)
         lm(6)=ndof(3,i2)
      endif
      call sband (iadres,lm,6)
      write (nsp,rec=ncard) lm,i1,i2,ek,bprop
c
      return
      end
c     --------------------------------------------------------------------ADDK
      subroutine addk (ndof,iadres,ncheck)
      implicit double precision (a-h,o-z)
      dimension ndof(1),ek(6,6),itmp(2),spring(3),iadres(1),bprop(10),
     +ncheck(1)
      character*1 blnk,check
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
      isprin=nbms
      blnk=' '
      write (not,1001)
      i2=0
      call izero (ek,72)
      call izero (bprop,20)
  100 continue
      call free
      call freeh (' ',check,1,1)
      if (check .eq. blnk) go to 500
c
      nbms=nbms+1
      ncard=numel+nbms
      call freei ('N',i1,1)
      ncheck(i1)=ncheck(i1)+1
      call freer ('K',spring,3)
      do 110 i=1,3
         ek(i,i)=spring(i)
  110 continue
      write (not,2001) i1,spring
      call lmdat (i1,i2,ndof,iadres,ek,ncard,neq,nsp,bprop)
c
      itmp(1)=0
      call freei ('G',itmp,2)
      incr=itmp(1)
      if (incr .eq. 0) go to 100
      mm=itmp(2)
      do 300 n=1,mm
         i1=i1+incr
         ncheck(i1)=ncheck(i1)+1
         nbms=nbms+1
         ncard=numel+nbms
         write (not,2001) i1,spring
         call lmdat (i1,i2,ndof,iadres,ek,ncard,neq,nsp,bprop)
  300 continue
      go to 100
  500 continue
      nsprin=nbms-isprin
      write (not,5001) nsprin
      write (ntm,5001) nsprin
c
 1001 format (15x,'ADDED LUMPED STIFFNESS COEFFICIENTS'//' Node no.',
     +5x,'Kx',10x,'Ky',10x,'Kxy')
 2001 format (i6,3e15.5)
 5001 format (' Total',i5,' lumped stiffness elements added to the',
     +' model')
c
      return
      end
c     -------------------------------------------------------------------READEK
      subroutine readek (lmdat,ekdat,icrack)
      implicit double precision (a-h,o-z)
      dimension lmdat(8,1),ekdat(64,1),lm(8),ek(64),ekb(46)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c.....assembles data in the core for windows operations
c.....                                          Sudip S.B./McGill/Sept. 7, 1992
      if (nbms .eq. 0) go to 210
      do 200 n=1,nbms
         ncard=numel+n
         read (nsp,rec=ncard) lm,ekb
         call copyi (lmdat(1,n),lm,8)
         call coprr (ekb,ekdat(1,n),46)
  200 continue
  210 continue
      if (icrack .eq. 0) return
      do 300 n=1,numel
         kdat=nbms+n
         read (nsp,rec=n) lm,ek
         call copyi (lmdat(1,kdat),lm,8)
         call coprr (ek,ekdat(1,kdat),64)
  300 continue
c
      return
      end
c     -------------------------------------------------------------------CHECKN
      subroutine checkn (ncheck,numnp,ndof,neqq)
      dimension ncheck(1),itmp(10),ndof(3,1)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c.....checks the connectivity of the nodes
c.....                                          Sudip S.B./Ecole/Feb. 28, 1995
      write (not, 1001)
      ntmp=0
      kk=0
      do 100 i=1,numnp
         if (ncheck(i) .eq. 0) then
            n1=ndof(1,i)
            n2=ndof(2,i)
            n3=ndof(3,i)
            if (n1 .ne. neqq .or. n2 .ne. neqq .or. n3 .ne. neqq) then
               ntmp=ntmp+1
               itmp(ntmp)=i
               if (ntmp .eq. 10  .or.  i .eq. numnp) then
                  write (not,1002) (itmp(k), k=1,ntmp)
                  kk=kk+ntmp
                  ntmp=0
               endif
            endif
         endif
         ncheck(i)=0
  100 continue
      if (kk .eq. 0) then
         write (not, 1003)
         return
      endif
c
 1001 format (///'Free nodes that are not connected to any element')
 1002 format (10i8)
 1003 format (10x,'********NONE*********')
c
      stop ' **  CHECK THE OUTPUT FILE TO INDENTIFY THE FREE NODES  **'
      end
